<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Register Class Teacher</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background-color: #f8f9fa;
        }

        .spinner-border {
            display: none;
        }

        .center-alert {
            position: fixed;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            z-index: 1000;
            text-align: center;
            display: none;
            background-color: #fff;
            padding: 40px;
            border-radius: 10px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }

        .checkmark-container {
            display: flex;
            justify-content: center;
            align-items: center;
            margin-bottom: 20px;
        }

        .checkmark {
            width: 100px;
            height: 100px;
            border-radius: 50%;
            background-color: #4caf50;
            position: relative;
        }

        .checkmark::before {
            content: '';
            position: absolute;
            top: 50%;
            left: 50%;
            width: 40px;
            height: 20px;
            border-left: 5px solid #fff;
            border-bottom: 5px solid #fff;
            transform: rotate(-45deg) translate(-50%, -50%);
            animation: checkmarkAnimation 1s ease forwards;
        }

        @keyframes checkmarkAnimation {
            0% {
                width: 0;
                height: 0;
            }
            50% {
                width: 20px;
                height: 10px;
            }
            100% {
                width: 40px;
                height: 20px;
            }
        }

        .ok-btn {
            background-color: #4caf50;
            color: white;
            border: none;
            padding: 10px 20px;
            font-size: 18px;
            cursor: pointer;
            border-radius: 5px;
            transition: background-color 0.3s;
        }

        .ok-btn:hover {
            background-color: #45a049;
        }

        #loading-message {
            text-align: center;
            font-weight: bold;
        }
    </style>
</head>

<body>
    <div class="container mt-5">
        <h2 class="text-center">Register Class Teacher</h2>
        <form id="teacherForm">
            <div class="mb-3">
                <label for="teacher_username" class="form-label">Username</label>
                <input type="text" class="form-control" id="teacher_username" name="teacher_username" required>
            </div>

            <div class="mb-3">
                <label for="class" class="form-label">Class</label>
                <select class="form-control" id="class" name="class" required>
                <option value="#" selected disabled> Please select class   </option>
                <option value="Form One"> Form 1   </option>
                <option value="Form Two"> Form 2   </option>
                <option value="Form Three"> Form 3   </option>
                <option value="Form Four"> Form 4   </option>

                </select>
            </div>

            <div class="mb-3">
                <label for="code" class="form-label">Password</label>
                <input type="password" class="form-control" id="code" name="code" required>
            </div>

            <button type="submit" class="btn btn-success">Register</button>

            <div class="spinner-border text-primary" role="status" id="loading-spinner">
                <span class="visually-hidden">Loading...</span>
            </div>
            <p id="loading-message" style="display: none;">Please wait while registering...</p>
        </form>
    </div>

    <!-- Alert Modal for Success -->
    <div id="alert-box" class="center-alert">
        <div class="checkmark-container">
            <div class="checkmark"></div>
        </div>
        <h5 class="text-success">Class teacher has been registered successfully!</h5>
        <button class="ok-btn mt-4" onclick="hideAlert()">Ok</button>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const form = document.getElementById('teacherForm');

            form.addEventListener('submit', function (e) {
                e.preventDefault();

                // Show loading spinner and message
                document.getElementById('loading-spinner').style.display = 'inline-block';
                document.getElementById('loading-message').style.display = 'block';

                const formData = new FormData(form);

                fetch('process_registerclassteacher.php', {
                    method: 'POST',
                    body: formData
                })
                .then(response => response.json())
                .then(data => {
                    // Hide loading spinner
                    document.getElementById('loading-spinner').style.display = 'none';
                    document.getElementById('loading-message').style.display = 'none';

                    // Show success alert if registration is successful
                    if (data.success) {
                        showAlert();
                    } else {
                        alert('Registration Failed: ' + data.message);
                    }
                });
            });
        });

        // Function to show alert
        function showAlert() {
            const alertBox = document.getElementById('alert-box');
            alertBox.style.display = 'block';
        }

        // Function to hide alert and reset form
        function hideAlert() {
            const alertBox = document.getElementById('alert-box');
            alertBox.style.display = 'none';
            document.getElementById('teacherForm').reset();
        }
    </script>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
